"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*!
Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from streamlit.proto import Exception_pb2 as _Exception_pb2
import builtins as _builtins
import sys
import typing as _typing

if sys.version_info >= (3, 10):
    from typing import TypeAlias as _TypeAlias
else:
    from typing_extensions import TypeAlias as _TypeAlias

DESCRIPTOR: _descriptor.FileDescriptor

@_typing.final
class SessionEvent(_message.Message):
    """A transient event sent to all browsers connected to an associated app."""

    DESCRIPTOR: _descriptor.Descriptor

    SCRIPT_CHANGED_ON_DISK_FIELD_NUMBER: _builtins.int
    SCRIPT_WAS_MANUALLY_STOPPED_FIELD_NUMBER: _builtins.int
    SCRIPT_COMPILATION_EXCEPTION_FIELD_NUMBER: _builtins.int
    script_changed_on_disk: _builtins.bool
    """The app's script changed on disk, but is *not* being re-run
    automatically. The browser should prompt the user to re-run.
    """
    script_was_manually_stopped: _builtins.bool
    """The app's script was running, but it was manually stopped before
    completion.
    """
    @_builtins.property
    def script_compilation_exception(self) -> _Exception_pb2.Exception:
        """Script compilation failed with an exception.
        We can't start running the script.
        """

    def __init__(
        self,
        *,
        script_changed_on_disk: _builtins.bool = ...,
        script_was_manually_stopped: _builtins.bool = ...,
        script_compilation_exception: _Exception_pb2.Exception | None = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["script_changed_on_disk", b"script_changed_on_disk", "script_compilation_exception", b"script_compilation_exception", "script_was_manually_stopped", b"script_was_manually_stopped", "type", b"type"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["script_changed_on_disk", b"script_changed_on_disk", "script_compilation_exception", b"script_compilation_exception", "script_was_manually_stopped", b"script_was_manually_stopped", "type", b"type"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_type: _TypeAlias = _typing.Literal["script_changed_on_disk", "script_was_manually_stopped", "script_compilation_exception"]  # noqa: Y015
    _WhichOneofArgType_type: _TypeAlias = _typing.Literal["type", b"type"]  # noqa: Y015
    def WhichOneof(self, oneof_group: _WhichOneofArgType_type) -> _WhichOneofReturnType_type | None: ...

Global___SessionEvent: _TypeAlias = SessionEvent  # noqa: Y015
