"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*!
Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

from collections import abc as _abc
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from streamlit.proto import AppPage_pb2 as _AppPage_pb2
from streamlit.proto import SessionStatus_pb2 as _SessionStatus_pb2
import builtins as _builtins
import sys
import typing as _typing

if sys.version_info >= (3, 10):
    from typing import TypeAlias as _TypeAlias
else:
    from typing_extensions import TypeAlias as _TypeAlias

if sys.version_info >= (3, 13):
    from warnings import deprecated as _deprecated
else:
    from typing_extensions import deprecated as _deprecated

DESCRIPTOR: _descriptor.FileDescriptor

@_typing.final
class NewSession(_message.Message):
    """NOTE: These proto types are used by some external services so need to
    remain relatively stable. While they aren't entirely set in stone, changing
    them may require a good amount of effort so should be avoided if possible.

    This is the first message that is sent when a new session starts.
    """

    DESCRIPTOR: _descriptor.Descriptor

    INITIALIZE_FIELD_NUMBER: _builtins.int
    SCRIPT_RUN_ID_FIELD_NUMBER: _builtins.int
    NAME_FIELD_NUMBER: _builtins.int
    MAIN_SCRIPT_PATH_FIELD_NUMBER: _builtins.int
    CONFIG_FIELD_NUMBER: _builtins.int
    CUSTOM_THEME_FIELD_NUMBER: _builtins.int
    APP_PAGES_FIELD_NUMBER: _builtins.int
    PAGE_SCRIPT_HASH_FIELD_NUMBER: _builtins.int
    FRAGMENT_IDS_THIS_RUN_FIELD_NUMBER: _builtins.int
    MAIN_SCRIPT_HASH_FIELD_NUMBER: _builtins.int
    script_run_id: _builtins.str
    """The script run ID"""
    name: _builtins.str
    """The basename of the script that launched this app. Example: 'foo.py'"""
    main_script_path: _builtins.str
    """The full path of the script that launched this app. Example:
    '/foo/bar/foo.py'
    """
    page_script_hash: _builtins.str
    """A hash of the script corresponding to the page currently being viewed."""
    main_script_hash: _builtins.str
    """Hash of the main script running (ie streamlit run main_script.py)"""
    @_builtins.property
    def initialize(self) -> Global___Initialize:
        """Initialization data. This data does *not* change from rerun to rerun,
        but we send it every time so that we don't have to track whether the
        client has already received it. The client is responsible for
        performing initialization logic only once.
        """

    @_builtins.property
    def config(self) -> Global___Config:
        """Config options that are (mostly) defined in the .streamlit/config.toml
        file.
        """

    @_builtins.property
    def custom_theme(self) -> Global___CustomThemeConfig:
        """Theme configuration options defined in the .streamlit/config.toml file.
        See the "theme" config section.
        """

    @_builtins.property
    def app_pages(self) -> _containers.RepeatedCompositeFieldContainer[_AppPage_pb2.AppPage]:
        """A list of all of this app's pages, in order and including the main page."""

    @_builtins.property
    def fragment_ids_this_run(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]:
        """The fragment IDs being run in this session if it corresponds to a fragment
        script run.
        """

    def __init__(
        self,
        *,
        initialize: Global___Initialize | None = ...,
        script_run_id: _builtins.str = ...,
        name: _builtins.str = ...,
        main_script_path: _builtins.str = ...,
        config: Global___Config | None = ...,
        custom_theme: Global___CustomThemeConfig | None = ...,
        app_pages: _abc.Iterable[_AppPage_pb2.AppPage] | None = ...,
        page_script_hash: _builtins.str = ...,
        fragment_ids_this_run: _abc.Iterable[_builtins.str] | None = ...,
        main_script_hash: _builtins.str = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["config", b"config", "custom_theme", b"custom_theme", "initialize", b"initialize"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["app_pages", b"app_pages", "config", b"config", "custom_theme", b"custom_theme", "fragment_ids_this_run", b"fragment_ids_this_run", "initialize", b"initialize", "main_script_hash", b"main_script_hash", "main_script_path", b"main_script_path", "name", b"name", "page_script_hash", b"page_script_hash", "script_run_id", b"script_run_id"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___NewSession: _TypeAlias = NewSession  # noqa: Y015

@_typing.final
class Initialize(_message.Message):
    """Contains the session status that existed at the time the user connected.
    The contents of this message don't change over the lifetime of the app by
    definition.
    """

    DESCRIPTOR: _descriptor.Descriptor

    USER_INFO_FIELD_NUMBER: _builtins.int
    ENVIRONMENT_INFO_FIELD_NUMBER: _builtins.int
    SESSION_STATUS_FIELD_NUMBER: _builtins.int
    COMMAND_LINE_FIELD_NUMBER: _builtins.int
    SESSION_ID_FIELD_NUMBER: _builtins.int
    IS_HELLO_FIELD_NUMBER: _builtins.int
    command_line: _builtins.str
    """DEPRECATED: We no longer send this to the frontend for security reasons.
    The actual command line as a string
    """
    session_id: _builtins.str
    """The AppSession.id for this connection's AppSession.
    This is used to associate uploaded files with the client that uploaded
    them.
    """
    is_hello: _builtins.bool
    """True if the command used to start this app was `streamlit hello`."""
    @_builtins.property
    def user_info(self) -> Global___UserInfo: ...
    @_builtins.property
    def environment_info(self) -> Global___EnvironmentInfo: ...
    @_builtins.property
    def session_status(self) -> _SessionStatus_pb2.SessionStatus:
        """The session status at the time the connection was established"""

    def __init__(
        self,
        *,
        user_info: Global___UserInfo | None = ...,
        environment_info: Global___EnvironmentInfo | None = ...,
        session_status: _SessionStatus_pb2.SessionStatus | None = ...,
        command_line: _builtins.str = ...,
        session_id: _builtins.str = ...,
        is_hello: _builtins.bool = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["environment_info", b"environment_info", "session_status", b"session_status", "user_info", b"user_info"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["command_line", b"command_line", "environment_info", b"environment_info", "is_hello", b"is_hello", "session_id", b"session_id", "session_status", b"session_status", "user_info", b"user_info"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___Initialize: _TypeAlias = Initialize  # noqa: Y015

@_typing.final
class Config(_message.Message):
    """App configuration options, initialized mainly from the
    .streamlit/config.toml file.
    """

    DESCRIPTOR: _descriptor.Descriptor

    class _ToolbarMode:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _ToolbarModeEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[Config._ToolbarMode.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        AUTO: Config._ToolbarMode.ValueType  # 0
        DEVELOPER: Config._ToolbarMode.ValueType  # 1
        VIEWER: Config._ToolbarMode.ValueType  # 2
        MINIMAL: Config._ToolbarMode.ValueType  # 3

    class ToolbarMode(_ToolbarMode, metaclass=_ToolbarModeEnumTypeWrapper):
        """See config option "client.toolbarMode"."""

    AUTO: Config.ToolbarMode.ValueType  # 0
    DEVELOPER: Config.ToolbarMode.ValueType  # 1
    VIEWER: Config.ToolbarMode.ValueType  # 2
    MINIMAL: Config.ToolbarMode.ValueType  # 3

    class _ShowErrorLinks:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _ShowErrorLinksEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[Config._ShowErrorLinks.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        SHOW_ERROR_LINKS_UNSPECIFIED: Config._ShowErrorLinks.ValueType  # 0
        SHOW_ERROR_LINKS_AUTO: Config._ShowErrorLinks.ValueType  # 1
        SHOW_ERROR_LINKS_TRUE: Config._ShowErrorLinks.ValueType  # 2
        SHOW_ERROR_LINKS_FALSE: Config._ShowErrorLinks.ValueType  # 3

    class ShowErrorLinks(_ShowErrorLinks, metaclass=_ShowErrorLinksEnumTypeWrapper):
        """See config option "client.showErrorLinks"."""

    SHOW_ERROR_LINKS_UNSPECIFIED: Config.ShowErrorLinks.ValueType  # 0
    SHOW_ERROR_LINKS_AUTO: Config.ShowErrorLinks.ValueType  # 1
    SHOW_ERROR_LINKS_TRUE: Config.ShowErrorLinks.ValueType  # 2
    SHOW_ERROR_LINKS_FALSE: Config.ShowErrorLinks.ValueType  # 3

    GATHER_USAGE_STATS_FIELD_NUMBER: _builtins.int
    MAX_CACHED_MESSAGE_AGE_FIELD_NUMBER: _builtins.int
    MAPBOX_TOKEN_FIELD_NUMBER: _builtins.int
    ALLOW_RUN_ON_SAVE_FIELD_NUMBER: _builtins.int
    HIDE_TOP_BAR_FIELD_NUMBER: _builtins.int
    HIDE_SIDEBAR_NAV_FIELD_NUMBER: _builtins.int
    TOOLBAR_MODE_FIELD_NUMBER: _builtins.int
    SHOW_ERROR_LINKS_FIELD_NUMBER: _builtins.int
    gather_usage_stats: _builtins.bool
    """See config option "browser.gatherUsageStats"."""
    max_cached_message_age: _builtins.int
    """See config option "global.maxCachedMessageAge"."""
    mapbox_token: _builtins.str
    """DEPRECATED: the mapbox token was moved to the DeckGlJsonChart message."""
    allow_run_on_save: _builtins.bool
    """See config option "server.allowRunOnSave"."""
    hide_top_bar: _builtins.bool
    """See config option "ui.hideTopBar"."""
    hide_sidebar_nav: _builtins.bool
    """See config option "client.showSidebarNavigation"."""
    toolbar_mode: Global___Config.ToolbarMode.ValueType
    show_error_links: Global___Config.ShowErrorLinks.ValueType
    def __init__(
        self,
        *,
        gather_usage_stats: _builtins.bool = ...,
        max_cached_message_age: _builtins.int = ...,
        mapbox_token: _builtins.str = ...,
        allow_run_on_save: _builtins.bool = ...,
        hide_top_bar: _builtins.bool = ...,
        hide_sidebar_nav: _builtins.bool = ...,
        toolbar_mode: Global___Config.ToolbarMode.ValueType = ...,
        show_error_links: Global___Config.ShowErrorLinks.ValueType = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["allow_run_on_save", b"allow_run_on_save", "gather_usage_stats", b"gather_usage_stats", "hide_sidebar_nav", b"hide_sidebar_nav", "hide_top_bar", b"hide_top_bar", "mapbox_token", b"mapbox_token", "max_cached_message_age", b"max_cached_message_age", "show_error_links", b"show_error_links", "toolbar_mode", b"toolbar_mode"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___Config: _TypeAlias = Config  # noqa: Y015

@_typing.final
class CustomThemeConfig(_message.Message):
    """Custom theme configuration options. Like other config options, these are set
    in .streamlit/config.toml.

    IMPORTANT: This message is passed in JSON format in a host-to-guest postMessage. So DO NOT
    rename its proto fields!
    """

    DESCRIPTOR: _descriptor.Descriptor

    class _BaseTheme:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _BaseThemeEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[CustomThemeConfig._BaseTheme.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        LIGHT: CustomThemeConfig._BaseTheme.ValueType  # 0
        DARK: CustomThemeConfig._BaseTheme.ValueType  # 1

    class BaseTheme(_BaseTheme, metaclass=_BaseThemeEnumTypeWrapper): ...
    LIGHT: CustomThemeConfig.BaseTheme.ValueType  # 0
    DARK: CustomThemeConfig.BaseTheme.ValueType  # 1

    class _FontFamily:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _FontFamilyEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[CustomThemeConfig._FontFamily.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        SANS_SERIF: CustomThemeConfig._FontFamily.ValueType  # 0
        SERIF: CustomThemeConfig._FontFamily.ValueType  # 1
        MONOSPACE: CustomThemeConfig._FontFamily.ValueType  # 2

    class FontFamily(_FontFamily, metaclass=_FontFamilyEnumTypeWrapper):
        """DEPRECATED: Use body_font instead:"""

    SANS_SERIF: CustomThemeConfig.FontFamily.ValueType  # 0
    SERIF: CustomThemeConfig.FontFamily.ValueType  # 1
    MONOSPACE: CustomThemeConfig.FontFamily.ValueType  # 2

    PRIMARY_COLOR_FIELD_NUMBER: _builtins.int
    SECONDARY_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    TEXT_COLOR_FIELD_NUMBER: _builtins.int
    FONT_FIELD_NUMBER: _builtins.int
    BASE_FIELD_NUMBER: _builtins.int
    WIDGET_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    WIDGET_BORDER_COLOR_FIELD_NUMBER: _builtins.int
    RADII_FIELD_NUMBER: _builtins.int
    HEADING_FONT_FIELD_NUMBER: _builtins.int
    BODY_FONT_FIELD_NUMBER: _builtins.int
    CODE_FONT_FIELD_NUMBER: _builtins.int
    FONT_FACES_FIELD_NUMBER: _builtins.int
    FONT_SOURCES_FIELD_NUMBER: _builtins.int
    FONT_SIZES_FIELD_NUMBER: _builtins.int
    SKELETON_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    BASE_RADIUS_FIELD_NUMBER: _builtins.int
    BUTTON_RADIUS_FIELD_NUMBER: _builtins.int
    BORDER_COLOR_FIELD_NUMBER: _builtins.int
    DATAFRAME_BORDER_COLOR_FIELD_NUMBER: _builtins.int
    SHOW_WIDGET_BORDER_FIELD_NUMBER: _builtins.int
    LINK_COLOR_FIELD_NUMBER: _builtins.int
    LINK_UNDERLINE_FIELD_NUMBER: _builtins.int
    BASE_FONT_SIZE_FIELD_NUMBER: _builtins.int
    BASE_FONT_WEIGHT_FIELD_NUMBER: _builtins.int
    CODE_FONT_WEIGHT_FIELD_NUMBER: _builtins.int
    CODE_FONT_SIZE_FIELD_NUMBER: _builtins.int
    HEADING_FONT_SIZES_FIELD_NUMBER: _builtins.int
    HEADING_FONT_WEIGHTS_FIELD_NUMBER: _builtins.int
    SHOW_SIDEBAR_BORDER_FIELD_NUMBER: _builtins.int
    CODE_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    CODE_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    DATAFRAME_HEADER_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    CHART_CATEGORICAL_COLORS_FIELD_NUMBER: _builtins.int
    CHART_SEQUENTIAL_COLORS_FIELD_NUMBER: _builtins.int
    CHART_DIVERGING_COLORS_FIELD_NUMBER: _builtins.int
    RED_COLOR_FIELD_NUMBER: _builtins.int
    ORANGE_COLOR_FIELD_NUMBER: _builtins.int
    YELLOW_COLOR_FIELD_NUMBER: _builtins.int
    BLUE_COLOR_FIELD_NUMBER: _builtins.int
    GREEN_COLOR_FIELD_NUMBER: _builtins.int
    VIOLET_COLOR_FIELD_NUMBER: _builtins.int
    GRAY_COLOR_FIELD_NUMBER: _builtins.int
    RED_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    ORANGE_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    YELLOW_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    BLUE_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    GREEN_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    VIOLET_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    GRAY_BACKGROUND_COLOR_FIELD_NUMBER: _builtins.int
    RED_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    ORANGE_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    YELLOW_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    BLUE_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    GREEN_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    VIOLET_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    GRAY_TEXT_COLOR_FIELD_NUMBER: _builtins.int
    SIDEBAR_FIELD_NUMBER: _builtins.int
    LIGHT_FIELD_NUMBER: _builtins.int
    DARK_FIELD_NUMBER: _builtins.int
    primary_color: _builtins.str
    secondary_background_color: _builtins.str
    background_color: _builtins.str
    text_color: _builtins.str
    font: Global___CustomThemeConfig.FontFamily.ValueType
    """DEPRECATED: Use body_font instead:"""
    base: Global___CustomThemeConfig.BaseTheme.ValueType
    widget_background_color: _builtins.str
    """DEPRECATED: This color is not applied anymore:"""
    widget_border_color: _builtins.str
    """DEPRECATED: Use the border_color and show_widget_border instead:"""
    heading_font: _builtins.str
    body_font: _builtins.str
    code_font: _builtins.str
    skeleton_background_color: _builtins.str
    """DEPRECATED: This color is not applied anymore:"""
    base_radius: _builtins.str
    button_radius: _builtins.str
    border_color: _builtins.str
    dataframe_border_color: _builtins.str
    show_widget_border: _builtins.bool
    link_color: _builtins.str
    link_underline: _builtins.bool
    base_font_size: _builtins.int
    base_font_weight: _builtins.int
    code_font_weight: _builtins.int
    code_font_size: _builtins.str
    show_sidebar_border: _builtins.bool
    code_text_color: _builtins.str
    code_background_color: _builtins.str
    dataframe_header_background_color: _builtins.str
    red_color: _builtins.str
    """Main color configs:"""
    orange_color: _builtins.str
    yellow_color: _builtins.str
    blue_color: _builtins.str
    green_color: _builtins.str
    violet_color: _builtins.str
    gray_color: _builtins.str
    red_background_color: _builtins.str
    """Background color configs:"""
    orange_background_color: _builtins.str
    yellow_background_color: _builtins.str
    blue_background_color: _builtins.str
    green_background_color: _builtins.str
    violet_background_color: _builtins.str
    gray_background_color: _builtins.str
    red_text_color: _builtins.str
    """Text color configs:"""
    orange_text_color: _builtins.str
    yellow_text_color: _builtins.str
    blue_text_color: _builtins.str
    green_text_color: _builtins.str
    violet_text_color: _builtins.str
    gray_text_color: _builtins.str
    @_builtins.property
    def radii(self) -> Global___Radii:
        """DEPRECATED: Please use the base_radius theme config instead:"""

    @_builtins.property
    def font_faces(self) -> _containers.RepeatedCompositeFieldContainer[Global___FontFace]: ...
    @_builtins.property
    def font_sources(self) -> _containers.RepeatedCompositeFieldContainer[Global___FontSource]: ...
    @_builtins.property
    def font_sizes(self) -> Global___FontSizes:
        """DEPRECATED: Please use the base_font_size theme config instead:"""

    @_builtins.property
    def heading_font_sizes(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]: ...
    @_builtins.property
    def heading_font_weights(self) -> _containers.RepeatedScalarFieldContainer[_builtins.int]: ...
    @_builtins.property
    def chart_categorical_colors(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]: ...
    @_builtins.property
    def chart_sequential_colors(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]: ...
    @_builtins.property
    def chart_diverging_colors(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]: ...
    @_builtins.property
    def sidebar(self) -> Global___CustomThemeConfig:
        """Theme sections:"""

    @_builtins.property
    def light(self) -> Global___CustomThemeConfig: ...
    @_builtins.property
    def dark(self) -> Global___CustomThemeConfig: ...
    def __init__(
        self,
        *,
        primary_color: _builtins.str = ...,
        secondary_background_color: _builtins.str = ...,
        background_color: _builtins.str = ...,
        text_color: _builtins.str = ...,
        font: Global___CustomThemeConfig.FontFamily.ValueType = ...,
        base: Global___CustomThemeConfig.BaseTheme.ValueType = ...,
        widget_background_color: _builtins.str = ...,
        widget_border_color: _builtins.str = ...,
        radii: Global___Radii | None = ...,
        heading_font: _builtins.str = ...,
        body_font: _builtins.str = ...,
        code_font: _builtins.str = ...,
        font_faces: _abc.Iterable[Global___FontFace] | None = ...,
        font_sources: _abc.Iterable[Global___FontSource] | None = ...,
        font_sizes: Global___FontSizes | None = ...,
        skeleton_background_color: _builtins.str = ...,
        base_radius: _builtins.str | None = ...,
        button_radius: _builtins.str | None = ...,
        border_color: _builtins.str | None = ...,
        dataframe_border_color: _builtins.str | None = ...,
        show_widget_border: _builtins.bool | None = ...,
        link_color: _builtins.str | None = ...,
        link_underline: _builtins.bool | None = ...,
        base_font_size: _builtins.int | None = ...,
        base_font_weight: _builtins.int | None = ...,
        code_font_weight: _builtins.int | None = ...,
        code_font_size: _builtins.str | None = ...,
        heading_font_sizes: _abc.Iterable[_builtins.str] | None = ...,
        heading_font_weights: _abc.Iterable[_builtins.int] | None = ...,
        show_sidebar_border: _builtins.bool | None = ...,
        code_text_color: _builtins.str | None = ...,
        code_background_color: _builtins.str | None = ...,
        dataframe_header_background_color: _builtins.str | None = ...,
        chart_categorical_colors: _abc.Iterable[_builtins.str] | None = ...,
        chart_sequential_colors: _abc.Iterable[_builtins.str] | None = ...,
        chart_diverging_colors: _abc.Iterable[_builtins.str] | None = ...,
        red_color: _builtins.str | None = ...,
        orange_color: _builtins.str | None = ...,
        yellow_color: _builtins.str | None = ...,
        blue_color: _builtins.str | None = ...,
        green_color: _builtins.str | None = ...,
        violet_color: _builtins.str | None = ...,
        gray_color: _builtins.str | None = ...,
        red_background_color: _builtins.str | None = ...,
        orange_background_color: _builtins.str | None = ...,
        yellow_background_color: _builtins.str | None = ...,
        blue_background_color: _builtins.str | None = ...,
        green_background_color: _builtins.str | None = ...,
        violet_background_color: _builtins.str | None = ...,
        gray_background_color: _builtins.str | None = ...,
        red_text_color: _builtins.str | None = ...,
        orange_text_color: _builtins.str | None = ...,
        yellow_text_color: _builtins.str | None = ...,
        blue_text_color: _builtins.str | None = ...,
        green_text_color: _builtins.str | None = ...,
        violet_text_color: _builtins.str | None = ...,
        gray_text_color: _builtins.str | None = ...,
        sidebar: Global___CustomThemeConfig | None = ...,
        light: Global___CustomThemeConfig | None = ...,
        dark: Global___CustomThemeConfig | None = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["_base_font_size", b"_base_font_size", "_base_font_weight", b"_base_font_weight", "_base_radius", b"_base_radius", "_blue_background_color", b"_blue_background_color", "_blue_color", b"_blue_color", "_blue_text_color", b"_blue_text_color", "_border_color", b"_border_color", "_button_radius", b"_button_radius", "_code_background_color", b"_code_background_color", "_code_font_size", b"_code_font_size", "_code_font_weight", b"_code_font_weight", "_code_text_color", b"_code_text_color", "_dark", b"_dark", "_dataframe_border_color", b"_dataframe_border_color", "_dataframe_header_background_color", b"_dataframe_header_background_color", "_gray_background_color", b"_gray_background_color", "_gray_color", b"_gray_color", "_gray_text_color", b"_gray_text_color", "_green_background_color", b"_green_background_color", "_green_color", b"_green_color", "_green_text_color", b"_green_text_color", "_light", b"_light", "_link_color", b"_link_color", "_link_underline", b"_link_underline", "_orange_background_color", b"_orange_background_color", "_orange_color", b"_orange_color", "_orange_text_color", b"_orange_text_color", "_red_background_color", b"_red_background_color", "_red_color", b"_red_color", "_red_text_color", b"_red_text_color", "_show_sidebar_border", b"_show_sidebar_border", "_show_widget_border", b"_show_widget_border", "_sidebar", b"_sidebar", "_violet_background_color", b"_violet_background_color", "_violet_color", b"_violet_color", "_violet_text_color", b"_violet_text_color", "_yellow_background_color", b"_yellow_background_color", "_yellow_color", b"_yellow_color", "_yellow_text_color", b"_yellow_text_color", "base_font_size", b"base_font_size", "base_font_weight", b"base_font_weight", "base_radius", b"base_radius", "blue_background_color", b"blue_background_color", "blue_color", b"blue_color", "blue_text_color", b"blue_text_color", "border_color", b"border_color", "button_radius", b"button_radius", "code_background_color", b"code_background_color", "code_font_size", b"code_font_size", "code_font_weight", b"code_font_weight", "code_text_color", b"code_text_color", "dark", b"dark", "dataframe_border_color", b"dataframe_border_color", "dataframe_header_background_color", b"dataframe_header_background_color", "font_sizes", b"font_sizes", "gray_background_color", b"gray_background_color", "gray_color", b"gray_color", "gray_text_color", b"gray_text_color", "green_background_color", b"green_background_color", "green_color", b"green_color", "green_text_color", b"green_text_color", "light", b"light", "link_color", b"link_color", "link_underline", b"link_underline", "orange_background_color", b"orange_background_color", "orange_color", b"orange_color", "orange_text_color", b"orange_text_color", "radii", b"radii", "red_background_color", b"red_background_color", "red_color", b"red_color", "red_text_color", b"red_text_color", "show_sidebar_border", b"show_sidebar_border", "show_widget_border", b"show_widget_border", "sidebar", b"sidebar", "violet_background_color", b"violet_background_color", "violet_color", b"violet_color", "violet_text_color", b"violet_text_color", "yellow_background_color", b"yellow_background_color", "yellow_color", b"yellow_color", "yellow_text_color", b"yellow_text_color"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["_base_font_size", b"_base_font_size", "_base_font_weight", b"_base_font_weight", "_base_radius", b"_base_radius", "_blue_background_color", b"_blue_background_color", "_blue_color", b"_blue_color", "_blue_text_color", b"_blue_text_color", "_border_color", b"_border_color", "_button_radius", b"_button_radius", "_code_background_color", b"_code_background_color", "_code_font_size", b"_code_font_size", "_code_font_weight", b"_code_font_weight", "_code_text_color", b"_code_text_color", "_dark", b"_dark", "_dataframe_border_color", b"_dataframe_border_color", "_dataframe_header_background_color", b"_dataframe_header_background_color", "_gray_background_color", b"_gray_background_color", "_gray_color", b"_gray_color", "_gray_text_color", b"_gray_text_color", "_green_background_color", b"_green_background_color", "_green_color", b"_green_color", "_green_text_color", b"_green_text_color", "_light", b"_light", "_link_color", b"_link_color", "_link_underline", b"_link_underline", "_orange_background_color", b"_orange_background_color", "_orange_color", b"_orange_color", "_orange_text_color", b"_orange_text_color", "_red_background_color", b"_red_background_color", "_red_color", b"_red_color", "_red_text_color", b"_red_text_color", "_show_sidebar_border", b"_show_sidebar_border", "_show_widget_border", b"_show_widget_border", "_sidebar", b"_sidebar", "_violet_background_color", b"_violet_background_color", "_violet_color", b"_violet_color", "_violet_text_color", b"_violet_text_color", "_yellow_background_color", b"_yellow_background_color", "_yellow_color", b"_yellow_color", "_yellow_text_color", b"_yellow_text_color", "background_color", b"background_color", "base", b"base", "base_font_size", b"base_font_size", "base_font_weight", b"base_font_weight", "base_radius", b"base_radius", "blue_background_color", b"blue_background_color", "blue_color", b"blue_color", "blue_text_color", b"blue_text_color", "body_font", b"body_font", "border_color", b"border_color", "button_radius", b"button_radius", "chart_categorical_colors", b"chart_categorical_colors", "chart_diverging_colors", b"chart_diverging_colors", "chart_sequential_colors", b"chart_sequential_colors", "code_background_color", b"code_background_color", "code_font", b"code_font", "code_font_size", b"code_font_size", "code_font_weight", b"code_font_weight", "code_text_color", b"code_text_color", "dark", b"dark", "dataframe_border_color", b"dataframe_border_color", "dataframe_header_background_color", b"dataframe_header_background_color", "font", b"font", "font_faces", b"font_faces", "font_sizes", b"font_sizes", "font_sources", b"font_sources", "gray_background_color", b"gray_background_color", "gray_color", b"gray_color", "gray_text_color", b"gray_text_color", "green_background_color", b"green_background_color", "green_color", b"green_color", "green_text_color", b"green_text_color", "heading_font", b"heading_font", "heading_font_sizes", b"heading_font_sizes", "heading_font_weights", b"heading_font_weights", "light", b"light", "link_color", b"link_color", "link_underline", b"link_underline", "orange_background_color", b"orange_background_color", "orange_color", b"orange_color", "orange_text_color", b"orange_text_color", "primary_color", b"primary_color", "radii", b"radii", "red_background_color", b"red_background_color", "red_color", b"red_color", "red_text_color", b"red_text_color", "secondary_background_color", b"secondary_background_color", "show_sidebar_border", b"show_sidebar_border", "show_widget_border", b"show_widget_border", "sidebar", b"sidebar", "skeleton_background_color", b"skeleton_background_color", "text_color", b"text_color", "violet_background_color", b"violet_background_color", "violet_color", b"violet_color", "violet_text_color", b"violet_text_color", "widget_background_color", b"widget_background_color", "widget_border_color", b"widget_border_color", "yellow_background_color", b"yellow_background_color", "yellow_color", b"yellow_color", "yellow_text_color", b"yellow_text_color"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__base_font_size: _TypeAlias = _typing.Literal["base_font_size"]  # noqa: Y015
    _WhichOneofArgType__base_font_size: _TypeAlias = _typing.Literal["_base_font_size", b"_base_font_size"]  # noqa: Y015
    _WhichOneofReturnType__base_font_weight: _TypeAlias = _typing.Literal["base_font_weight"]  # noqa: Y015
    _WhichOneofArgType__base_font_weight: _TypeAlias = _typing.Literal["_base_font_weight", b"_base_font_weight"]  # noqa: Y015
    _WhichOneofReturnType__base_radius: _TypeAlias = _typing.Literal["base_radius"]  # noqa: Y015
    _WhichOneofArgType__base_radius: _TypeAlias = _typing.Literal["_base_radius", b"_base_radius"]  # noqa: Y015
    _WhichOneofReturnType__blue_background_color: _TypeAlias = _typing.Literal["blue_background_color"]  # noqa: Y015
    _WhichOneofArgType__blue_background_color: _TypeAlias = _typing.Literal["_blue_background_color", b"_blue_background_color"]  # noqa: Y015
    _WhichOneofReturnType__blue_color: _TypeAlias = _typing.Literal["blue_color"]  # noqa: Y015
    _WhichOneofArgType__blue_color: _TypeAlias = _typing.Literal["_blue_color", b"_blue_color"]  # noqa: Y015
    _WhichOneofReturnType__blue_text_color: _TypeAlias = _typing.Literal["blue_text_color"]  # noqa: Y015
    _WhichOneofArgType__blue_text_color: _TypeAlias = _typing.Literal["_blue_text_color", b"_blue_text_color"]  # noqa: Y015
    _WhichOneofReturnType__border_color: _TypeAlias = _typing.Literal["border_color"]  # noqa: Y015
    _WhichOneofArgType__border_color: _TypeAlias = _typing.Literal["_border_color", b"_border_color"]  # noqa: Y015
    _WhichOneofReturnType__button_radius: _TypeAlias = _typing.Literal["button_radius"]  # noqa: Y015
    _WhichOneofArgType__button_radius: _TypeAlias = _typing.Literal["_button_radius", b"_button_radius"]  # noqa: Y015
    _WhichOneofReturnType__code_background_color: _TypeAlias = _typing.Literal["code_background_color"]  # noqa: Y015
    _WhichOneofArgType__code_background_color: _TypeAlias = _typing.Literal["_code_background_color", b"_code_background_color"]  # noqa: Y015
    _WhichOneofReturnType__code_font_size: _TypeAlias = _typing.Literal["code_font_size"]  # noqa: Y015
    _WhichOneofArgType__code_font_size: _TypeAlias = _typing.Literal["_code_font_size", b"_code_font_size"]  # noqa: Y015
    _WhichOneofReturnType__code_font_weight: _TypeAlias = _typing.Literal["code_font_weight"]  # noqa: Y015
    _WhichOneofArgType__code_font_weight: _TypeAlias = _typing.Literal["_code_font_weight", b"_code_font_weight"]  # noqa: Y015
    _WhichOneofReturnType__code_text_color: _TypeAlias = _typing.Literal["code_text_color"]  # noqa: Y015
    _WhichOneofArgType__code_text_color: _TypeAlias = _typing.Literal["_code_text_color", b"_code_text_color"]  # noqa: Y015
    _WhichOneofReturnType__dark: _TypeAlias = _typing.Literal["dark"]  # noqa: Y015
    _WhichOneofArgType__dark: _TypeAlias = _typing.Literal["_dark", b"_dark"]  # noqa: Y015
    _WhichOneofReturnType__dataframe_border_color: _TypeAlias = _typing.Literal["dataframe_border_color"]  # noqa: Y015
    _WhichOneofArgType__dataframe_border_color: _TypeAlias = _typing.Literal["_dataframe_border_color", b"_dataframe_border_color"]  # noqa: Y015
    _WhichOneofReturnType__dataframe_header_background_color: _TypeAlias = _typing.Literal["dataframe_header_background_color"]  # noqa: Y015
    _WhichOneofArgType__dataframe_header_background_color: _TypeAlias = _typing.Literal["_dataframe_header_background_color", b"_dataframe_header_background_color"]  # noqa: Y015
    _WhichOneofReturnType__gray_background_color: _TypeAlias = _typing.Literal["gray_background_color"]  # noqa: Y015
    _WhichOneofArgType__gray_background_color: _TypeAlias = _typing.Literal["_gray_background_color", b"_gray_background_color"]  # noqa: Y015
    _WhichOneofReturnType__gray_color: _TypeAlias = _typing.Literal["gray_color"]  # noqa: Y015
    _WhichOneofArgType__gray_color: _TypeAlias = _typing.Literal["_gray_color", b"_gray_color"]  # noqa: Y015
    _WhichOneofReturnType__gray_text_color: _TypeAlias = _typing.Literal["gray_text_color"]  # noqa: Y015
    _WhichOneofArgType__gray_text_color: _TypeAlias = _typing.Literal["_gray_text_color", b"_gray_text_color"]  # noqa: Y015
    _WhichOneofReturnType__green_background_color: _TypeAlias = _typing.Literal["green_background_color"]  # noqa: Y015
    _WhichOneofArgType__green_background_color: _TypeAlias = _typing.Literal["_green_background_color", b"_green_background_color"]  # noqa: Y015
    _WhichOneofReturnType__green_color: _TypeAlias = _typing.Literal["green_color"]  # noqa: Y015
    _WhichOneofArgType__green_color: _TypeAlias = _typing.Literal["_green_color", b"_green_color"]  # noqa: Y015
    _WhichOneofReturnType__green_text_color: _TypeAlias = _typing.Literal["green_text_color"]  # noqa: Y015
    _WhichOneofArgType__green_text_color: _TypeAlias = _typing.Literal["_green_text_color", b"_green_text_color"]  # noqa: Y015
    _WhichOneofReturnType__light: _TypeAlias = _typing.Literal["light"]  # noqa: Y015
    _WhichOneofArgType__light: _TypeAlias = _typing.Literal["_light", b"_light"]  # noqa: Y015
    _WhichOneofReturnType__link_color: _TypeAlias = _typing.Literal["link_color"]  # noqa: Y015
    _WhichOneofArgType__link_color: _TypeAlias = _typing.Literal["_link_color", b"_link_color"]  # noqa: Y015
    _WhichOneofReturnType__link_underline: _TypeAlias = _typing.Literal["link_underline"]  # noqa: Y015
    _WhichOneofArgType__link_underline: _TypeAlias = _typing.Literal["_link_underline", b"_link_underline"]  # noqa: Y015
    _WhichOneofReturnType__orange_background_color: _TypeAlias = _typing.Literal["orange_background_color"]  # noqa: Y015
    _WhichOneofArgType__orange_background_color: _TypeAlias = _typing.Literal["_orange_background_color", b"_orange_background_color"]  # noqa: Y015
    _WhichOneofReturnType__orange_color: _TypeAlias = _typing.Literal["orange_color"]  # noqa: Y015
    _WhichOneofArgType__orange_color: _TypeAlias = _typing.Literal["_orange_color", b"_orange_color"]  # noqa: Y015
    _WhichOneofReturnType__orange_text_color: _TypeAlias = _typing.Literal["orange_text_color"]  # noqa: Y015
    _WhichOneofArgType__orange_text_color: _TypeAlias = _typing.Literal["_orange_text_color", b"_orange_text_color"]  # noqa: Y015
    _WhichOneofReturnType__red_background_color: _TypeAlias = _typing.Literal["red_background_color"]  # noqa: Y015
    _WhichOneofArgType__red_background_color: _TypeAlias = _typing.Literal["_red_background_color", b"_red_background_color"]  # noqa: Y015
    _WhichOneofReturnType__red_color: _TypeAlias = _typing.Literal["red_color"]  # noqa: Y015
    _WhichOneofArgType__red_color: _TypeAlias = _typing.Literal["_red_color", b"_red_color"]  # noqa: Y015
    _WhichOneofReturnType__red_text_color: _TypeAlias = _typing.Literal["red_text_color"]  # noqa: Y015
    _WhichOneofArgType__red_text_color: _TypeAlias = _typing.Literal["_red_text_color", b"_red_text_color"]  # noqa: Y015
    _WhichOneofReturnType__show_sidebar_border: _TypeAlias = _typing.Literal["show_sidebar_border"]  # noqa: Y015
    _WhichOneofArgType__show_sidebar_border: _TypeAlias = _typing.Literal["_show_sidebar_border", b"_show_sidebar_border"]  # noqa: Y015
    _WhichOneofReturnType__show_widget_border: _TypeAlias = _typing.Literal["show_widget_border"]  # noqa: Y015
    _WhichOneofArgType__show_widget_border: _TypeAlias = _typing.Literal["_show_widget_border", b"_show_widget_border"]  # noqa: Y015
    _WhichOneofReturnType__sidebar: _TypeAlias = _typing.Literal["sidebar"]  # noqa: Y015
    _WhichOneofArgType__sidebar: _TypeAlias = _typing.Literal["_sidebar", b"_sidebar"]  # noqa: Y015
    _WhichOneofReturnType__violet_background_color: _TypeAlias = _typing.Literal["violet_background_color"]  # noqa: Y015
    _WhichOneofArgType__violet_background_color: _TypeAlias = _typing.Literal["_violet_background_color", b"_violet_background_color"]  # noqa: Y015
    _WhichOneofReturnType__violet_color: _TypeAlias = _typing.Literal["violet_color"]  # noqa: Y015
    _WhichOneofArgType__violet_color: _TypeAlias = _typing.Literal["_violet_color", b"_violet_color"]  # noqa: Y015
    _WhichOneofReturnType__violet_text_color: _TypeAlias = _typing.Literal["violet_text_color"]  # noqa: Y015
    _WhichOneofArgType__violet_text_color: _TypeAlias = _typing.Literal["_violet_text_color", b"_violet_text_color"]  # noqa: Y015
    _WhichOneofReturnType__yellow_background_color: _TypeAlias = _typing.Literal["yellow_background_color"]  # noqa: Y015
    _WhichOneofArgType__yellow_background_color: _TypeAlias = _typing.Literal["_yellow_background_color", b"_yellow_background_color"]  # noqa: Y015
    _WhichOneofReturnType__yellow_color: _TypeAlias = _typing.Literal["yellow_color"]  # noqa: Y015
    _WhichOneofArgType__yellow_color: _TypeAlias = _typing.Literal["_yellow_color", b"_yellow_color"]  # noqa: Y015
    _WhichOneofReturnType__yellow_text_color: _TypeAlias = _typing.Literal["yellow_text_color"]  # noqa: Y015
    _WhichOneofArgType__yellow_text_color: _TypeAlias = _typing.Literal["_yellow_text_color", b"_yellow_text_color"]  # noqa: Y015
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__base_font_size) -> _WhichOneofReturnType__base_font_size | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__base_font_weight) -> _WhichOneofReturnType__base_font_weight | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__base_radius) -> _WhichOneofReturnType__base_radius | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__blue_background_color) -> _WhichOneofReturnType__blue_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__blue_color) -> _WhichOneofReturnType__blue_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__blue_text_color) -> _WhichOneofReturnType__blue_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__border_color) -> _WhichOneofReturnType__border_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__button_radius) -> _WhichOneofReturnType__button_radius | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__code_background_color) -> _WhichOneofReturnType__code_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__code_font_size) -> _WhichOneofReturnType__code_font_size | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__code_font_weight) -> _WhichOneofReturnType__code_font_weight | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__code_text_color) -> _WhichOneofReturnType__code_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__dark) -> _WhichOneofReturnType__dark | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__dataframe_border_color) -> _WhichOneofReturnType__dataframe_border_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__dataframe_header_background_color) -> _WhichOneofReturnType__dataframe_header_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__gray_background_color) -> _WhichOneofReturnType__gray_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__gray_color) -> _WhichOneofReturnType__gray_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__gray_text_color) -> _WhichOneofReturnType__gray_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__green_background_color) -> _WhichOneofReturnType__green_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__green_color) -> _WhichOneofReturnType__green_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__green_text_color) -> _WhichOneofReturnType__green_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__light) -> _WhichOneofReturnType__light | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__link_color) -> _WhichOneofReturnType__link_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__link_underline) -> _WhichOneofReturnType__link_underline | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__orange_background_color) -> _WhichOneofReturnType__orange_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__orange_color) -> _WhichOneofReturnType__orange_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__orange_text_color) -> _WhichOneofReturnType__orange_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__red_background_color) -> _WhichOneofReturnType__red_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__red_color) -> _WhichOneofReturnType__red_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__red_text_color) -> _WhichOneofReturnType__red_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__show_sidebar_border) -> _WhichOneofReturnType__show_sidebar_border | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__show_widget_border) -> _WhichOneofReturnType__show_widget_border | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__sidebar) -> _WhichOneofReturnType__sidebar | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__violet_background_color) -> _WhichOneofReturnType__violet_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__violet_color) -> _WhichOneofReturnType__violet_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__violet_text_color) -> _WhichOneofReturnType__violet_text_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__yellow_background_color) -> _WhichOneofReturnType__yellow_background_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__yellow_color) -> _WhichOneofReturnType__yellow_color | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__yellow_text_color) -> _WhichOneofReturnType__yellow_text_color | None: ...

Global___CustomThemeConfig: _TypeAlias = CustomThemeConfig  # noqa: Y015

@_typing.final
class FontFace(_message.Message):
    DESCRIPTOR: _descriptor.Descriptor

    URL_FIELD_NUMBER: _builtins.int
    FAMILY_FIELD_NUMBER: _builtins.int
    WEIGHT_FIELD_NUMBER: _builtins.int
    WEIGHT_RANGE_FIELD_NUMBER: _builtins.int
    STYLE_FIELD_NUMBER: _builtins.int
    UNICODE_RANGE_FIELD_NUMBER: _builtins.int
    url: _builtins.str
    family: _builtins.str
    """Equivalent to font-family @font-face CSS property."""
    @_builtins.property
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def weight(self) -> _builtins.int:
        """DEPRECATED: Use weight_range instead which supports single weights & weight ranges."""

    @weight.setter
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def weight(self, value: _builtins.int) -> None:
        """DEPRECATED: Use weight_range instead which supports single weights & weight ranges."""

    weight_range: _builtins.str
    """Equivalent to font-weight @font-face CSS property."""
    style: _builtins.str
    """Equivalent to font-style @font-face CSS property."""
    unicode_range: _builtins.str
    """Equivalent to unicode-range @font-face CSS property."""
    def __init__(
        self,
        *,
        url: _builtins.str = ...,
        family: _builtins.str = ...,
        weight: _builtins.int = ...,
        weight_range: _builtins.str = ...,
        style: _builtins.str = ...,
        unicode_range: _builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["family", b"family", "style", b"style", "unicode_range", b"unicode_range", "url", b"url", "weight", b"weight", "weight_range", b"weight_range"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___FontFace: _TypeAlias = FontFace  # noqa: Y015

@_typing.final
class FontSource(_message.Message):
    DESCRIPTOR: _descriptor.Descriptor

    CONFIG_NAME_FIELD_NUMBER: _builtins.int
    SOURCE_URL_FIELD_NUMBER: _builtins.int
    config_name: _builtins.str
    """Supports passing links to font config options - these are the sources
    used in the <link> tag (href) to embed the font in html
    """
    source_url: _builtins.str
    def __init__(
        self,
        *,
        config_name: _builtins.str = ...,
        source_url: _builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["config_name", b"config_name", "source_url", b"source_url"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___FontSource: _TypeAlias = FontSource  # noqa: Y015

@_typing.final
class Radii(_message.Message):
    """DEPRECATED: Please use the base_radius theme config instead."""

    DESCRIPTOR: _descriptor.Descriptor

    BASE_WIDGET_RADIUS_FIELD_NUMBER: _builtins.int
    CHECKBOX_RADIUS_FIELD_NUMBER: _builtins.int
    base_widget_radius: _builtins.int
    """In pixels."""
    checkbox_radius: _builtins.int
    def __init__(
        self,
        *,
        base_widget_radius: _builtins.int = ...,
        checkbox_radius: _builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["base_widget_radius", b"base_widget_radius", "checkbox_radius", b"checkbox_radius"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___Radii: _TypeAlias = Radii  # noqa: Y015

@_typing.final
class FontSizes(_message.Message):
    """DEPRECATED: Please use the base_font_size theme config instead:"""

    DESCRIPTOR: _descriptor.Descriptor

    TINY_FONT_SIZE_FIELD_NUMBER: _builtins.int
    SMALL_FONT_SIZE_FIELD_NUMBER: _builtins.int
    BASE_FONT_SIZE_FIELD_NUMBER: _builtins.int
    tiny_font_size: _builtins.int
    """In pixels."""
    small_font_size: _builtins.int
    base_font_size: _builtins.int
    def __init__(
        self,
        *,
        tiny_font_size: _builtins.int = ...,
        small_font_size: _builtins.int = ...,
        base_font_size: _builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["base_font_size", b"base_font_size", "small_font_size", b"small_font_size", "tiny_font_size", b"tiny_font_size"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___FontSizes: _TypeAlias = FontSizes  # noqa: Y015

@_typing.final
class UserInfo(_message.Message):
    """Data that identifies the Streamlit app creator.
    Does not change over the app's lifetime.
    """

    DESCRIPTOR: _descriptor.Descriptor

    INSTALLATION_ID_FIELD_NUMBER: _builtins.int
    INSTALLATION_ID_V3_FIELD_NUMBER: _builtins.int
    INSTALLATION_ID_V4_FIELD_NUMBER: _builtins.int
    installation_id: _builtins.str
    installation_id_v3: _builtins.str
    installation_id_v4: _builtins.str
    def __init__(
        self,
        *,
        installation_id: _builtins.str = ...,
        installation_id_v3: _builtins.str = ...,
        installation_id_v4: _builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["installation_id", b"installation_id", "installation_id_v3", b"installation_id_v3", "installation_id_v4", b"installation_id_v4"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UserInfo: _TypeAlias = UserInfo  # noqa: Y015

@_typing.final
class EnvironmentInfo(_message.Message):
    """Data that identifies the Streamlit app's environment.
    Does not change over the app lifetime.

    NB: unlike most of our protobuf data, the EnvironmentInfo message (and all
    its ancestors' IDs) *must* maintain backward- and forward-compatibility.
    When a Streamlit instance is updated to a new version, all connected clients
    will be outdated. Those clients need to be able to read the
    `streamlit_version` property so they can auto-update to the new version.
    """

    DESCRIPTOR: _descriptor.Descriptor

    STREAMLIT_VERSION_FIELD_NUMBER: _builtins.int
    PYTHON_VERSION_FIELD_NUMBER: _builtins.int
    SERVER_OS_FIELD_NUMBER: _builtins.int
    HAS_DISPLAY_FIELD_NUMBER: _builtins.int
    streamlit_version: _builtins.str
    python_version: _builtins.str
    server_os: _builtins.str
    """The name of the OS. Typically "windows", "mac", "linux",
    but can take other values like "ios", "android", "freebsd8".
    See https://docs.python.org/3/library/sys.html#sys.platform
    """
    has_display: _builtins.bool
    """True if Linux/BSD and DISPLAY or WAYLAND_DISPLAY environment variables are
    set. This is used so we can tell when Streamlit is being executed in order
    to develop the app (has_display = true) or to serve the app (has_display =
    false).
    """
    def __init__(
        self,
        *,
        streamlit_version: _builtins.str = ...,
        python_version: _builtins.str = ...,
        server_os: _builtins.str = ...,
        has_display: _builtins.bool = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["has_display", b"has_display", "python_version", b"python_version", "server_os", b"server_os", "streamlit_version", b"streamlit_version"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___EnvironmentInfo: _TypeAlias = EnvironmentInfo  # noqa: Y015
