"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*!
Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

from collections import abc as _abc
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from google.protobuf.internal import containers as _containers
from streamlit.proto import ArrowData_pb2 as _ArrowData_pb2
import builtins as _builtins
import sys
import typing as _typing

if sys.version_info >= (3, 10):
    from typing import TypeAlias as _TypeAlias
else:
    from typing_extensions import TypeAlias as _TypeAlias

DESCRIPTOR: _descriptor.FileDescriptor

@_typing.final
class MixedData(_message.Message):
    """Mixed data structure that allows JSON with embedded Arrow references"""

    DESCRIPTOR: _descriptor.Descriptor

    @_typing.final
    class ArrowBlobsEntry(_message.Message):
        DESCRIPTOR: _descriptor.Descriptor

        KEY_FIELD_NUMBER: _builtins.int
        VALUE_FIELD_NUMBER: _builtins.int
        key: _builtins.str
        @_builtins.property
        def value(self) -> _ArrowData_pb2.ArrowData: ...
        def __init__(
            self,
            *,
            key: _builtins.str = ...,
            value: _ArrowData_pb2.ArrowData | None = ...,
        ) -> None: ...
        _HasFieldArgType: _TypeAlias = _typing.Literal["value", b"value"]  # noqa: Y015
        def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
        _ClearFieldArgType: _TypeAlias = _typing.Literal["key", b"key", "value", b"value"]  # noqa: Y015
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    JSON_FIELD_NUMBER: _builtins.int
    ARROW_BLOBS_FIELD_NUMBER: _builtins.int
    json: _builtins.str
    """The main JSON structure with arrow references replaced by placeholders"""
    @_builtins.property
    def arrow_blobs(self) -> _containers.MessageMap[_builtins.str, _ArrowData_pb2.ArrowData]:
        """Map of arrow data blobs keyed by reference ID"""

    def __init__(
        self,
        *,
        json: _builtins.str = ...,
        arrow_blobs: _abc.Mapping[_builtins.str, _ArrowData_pb2.ArrowData] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["arrow_blobs", b"arrow_blobs", "json", b"json"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___MixedData: _TypeAlias = MixedData  # noqa: Y015

@_typing.final
class BidiComponent(_message.Message):
    """Represents an instance of a bidirectional component."""

    DESCRIPTOR: _descriptor.Descriptor

    ID_FIELD_NUMBER: _builtins.int
    COMPONENT_NAME_FIELD_NUMBER: _builtins.int
    JS_CONTENT_FIELD_NUMBER: _builtins.int
    JS_SOURCE_PATH_FIELD_NUMBER: _builtins.int
    FORM_ID_FIELD_NUMBER: _builtins.int
    HTML_CONTENT_FIELD_NUMBER: _builtins.int
    CSS_CONTENT_FIELD_NUMBER: _builtins.int
    CSS_SOURCE_PATH_FIELD_NUMBER: _builtins.int
    ISOLATE_STYLES_FIELD_NUMBER: _builtins.int
    JSON_FIELD_NUMBER: _builtins.int
    ARROW_DATA_FIELD_NUMBER: _builtins.int
    BYTES_FIELD_NUMBER: _builtins.int
    MIXED_FIELD_NUMBER: _builtins.int
    id: _builtins.str
    """The ID of the widget instance."""
    component_name: _builtins.str
    """The registered name of the component."""
    js_content: _builtins.str
    """The JavaScript content provided by the developer."""
    js_source_path: _builtins.str
    """The source path for the JavaScript content."""
    form_id: _builtins.str
    """The ID of the form this component belongs to, if any."""
    html_content: _builtins.str
    """The HTML content provided by the developer."""
    css_content: _builtins.str
    """The CSS content provided by the developer."""
    css_source_path: _builtins.str
    """The source path for the CSS content."""
    isolate_styles: _builtins.bool
    """Whether to isolate styles from the parent."""
    json: _builtins.str
    """JSON-serialized value for generic data payloads."""
    bytes: _builtins.bytes
    """Arbitrary bytes payload."""
    @_builtins.property
    def arrow_data(self) -> _ArrowData_pb2.ArrowData:
        """Data-only Apache Arrow buffer for dataframe-like payloads."""

    @_builtins.property
    def mixed(self) -> Global___MixedData:
        """Mixed data with JSON structure + embedded Arrow references"""

    def __init__(
        self,
        *,
        id: _builtins.str = ...,
        component_name: _builtins.str = ...,
        js_content: _builtins.str | None = ...,
        js_source_path: _builtins.str | None = ...,
        form_id: _builtins.str = ...,
        html_content: _builtins.str | None = ...,
        css_content: _builtins.str | None = ...,
        css_source_path: _builtins.str | None = ...,
        isolate_styles: _builtins.bool = ...,
        json: _builtins.str = ...,
        arrow_data: _ArrowData_pb2.ArrowData | None = ...,
        bytes: _builtins.bytes = ...,
        mixed: Global___MixedData | None = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["_css_content", b"_css_content", "_css_source_path", b"_css_source_path", "_html_content", b"_html_content", "_js_content", b"_js_content", "_js_source_path", b"_js_source_path", "arrow_data", b"arrow_data", "bytes", b"bytes", "css_content", b"css_content", "css_source_path", b"css_source_path", "data", b"data", "html_content", b"html_content", "js_content", b"js_content", "js_source_path", b"js_source_path", "json", b"json", "mixed", b"mixed"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["_css_content", b"_css_content", "_css_source_path", b"_css_source_path", "_html_content", b"_html_content", "_js_content", b"_js_content", "_js_source_path", b"_js_source_path", "arrow_data", b"arrow_data", "bytes", b"bytes", "component_name", b"component_name", "css_content", b"css_content", "css_source_path", b"css_source_path", "data", b"data", "form_id", b"form_id", "html_content", b"html_content", "id", b"id", "isolate_styles", b"isolate_styles", "js_content", b"js_content", "js_source_path", b"js_source_path", "json", b"json", "mixed", b"mixed"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__css_content: _TypeAlias = _typing.Literal["css_content"]  # noqa: Y015
    _WhichOneofArgType__css_content: _TypeAlias = _typing.Literal["_css_content", b"_css_content"]  # noqa: Y015
    _WhichOneofReturnType__css_source_path: _TypeAlias = _typing.Literal["css_source_path"]  # noqa: Y015
    _WhichOneofArgType__css_source_path: _TypeAlias = _typing.Literal["_css_source_path", b"_css_source_path"]  # noqa: Y015
    _WhichOneofReturnType__html_content: _TypeAlias = _typing.Literal["html_content"]  # noqa: Y015
    _WhichOneofArgType__html_content: _TypeAlias = _typing.Literal["_html_content", b"_html_content"]  # noqa: Y015
    _WhichOneofReturnType__js_content: _TypeAlias = _typing.Literal["js_content"]  # noqa: Y015
    _WhichOneofArgType__js_content: _TypeAlias = _typing.Literal["_js_content", b"_js_content"]  # noqa: Y015
    _WhichOneofReturnType__js_source_path: _TypeAlias = _typing.Literal["js_source_path"]  # noqa: Y015
    _WhichOneofArgType__js_source_path: _TypeAlias = _typing.Literal["_js_source_path", b"_js_source_path"]  # noqa: Y015
    _WhichOneofReturnType_data: _TypeAlias = _typing.Literal["json", "arrow_data", "bytes", "mixed"]  # noqa: Y015
    _WhichOneofArgType_data: _TypeAlias = _typing.Literal["data", b"data"]  # noqa: Y015
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__css_content) -> _WhichOneofReturnType__css_content | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__css_source_path) -> _WhichOneofReturnType__css_source_path | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__html_content) -> _WhichOneofReturnType__html_content | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__js_content) -> _WhichOneofReturnType__js_content | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__js_source_path) -> _WhichOneofReturnType__js_source_path | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType_data) -> _WhichOneofReturnType_data | None: ...

Global___BidiComponent: _TypeAlias = BidiComponent  # noqa: Y015
