"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
*!
Copyright (c) Streamlit Inc. (2018-2022) Snowflake Inc. (2022-2026)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

from collections import abc as _abc
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
import builtins as _builtins
import sys
import typing as _typing

if sys.version_info >= (3, 10):
    from typing import TypeAlias as _TypeAlias
else:
    from typing_extensions import TypeAlias as _TypeAlias

if sys.version_info >= (3, 13):
    from warnings import deprecated as _deprecated
else:
    from typing_extensions import deprecated as _deprecated

DESCRIPTOR: _descriptor.FileDescriptor

@_typing.final
class Arrow(_message.Message):
    DESCRIPTOR: _descriptor.Descriptor

    class _EditingMode:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _EditingModeEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[Arrow._EditingMode.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        READ_ONLY: Arrow._EditingMode.ValueType  # 0
        """Read-only table."""
        FIXED: Arrow._EditingMode.ValueType  # 1
        """Activates editing but only allow editing of existing cells."""
        DYNAMIC: Arrow._EditingMode.ValueType  # 2
        """Activates editing and allow adding & deleting rows."""
        ADD_ONLY: Arrow._EditingMode.ValueType  # 3
        """Activates editing and allow adding rows (no deleting)."""
        DELETE_ONLY: Arrow._EditingMode.ValueType  # 4
        """Activates editing and allow deleting rows (no adding)."""

    class EditingMode(_EditingMode, metaclass=_EditingModeEnumTypeWrapper):
        """Available editing modes:"""

    READ_ONLY: Arrow.EditingMode.ValueType  # 0
    """Read-only table."""
    FIXED: Arrow.EditingMode.ValueType  # 1
    """Activates editing but only allow editing of existing cells."""
    DYNAMIC: Arrow.EditingMode.ValueType  # 2
    """Activates editing and allow adding & deleting rows."""
    ADD_ONLY: Arrow.EditingMode.ValueType  # 3
    """Activates editing and allow adding rows (no deleting)."""
    DELETE_ONLY: Arrow.EditingMode.ValueType  # 4
    """Activates editing and allow deleting rows (no adding)."""

    class _SelectionMode:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _SelectionModeEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[Arrow._SelectionMode.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        SINGLE_ROW: Arrow._SelectionMode.ValueType  # 0
        """Only one row can be selected at a time."""
        MULTI_ROW: Arrow._SelectionMode.ValueType  # 1
        """Multiple rows can be selected at a time."""
        SINGLE_COLUMN: Arrow._SelectionMode.ValueType  # 2
        """Only one column can be selected at a time."""
        MULTI_COLUMN: Arrow._SelectionMode.ValueType  # 3
        """Multiple columns can be selected at a time."""
        SINGLE_CELL: Arrow._SelectionMode.ValueType  # 4
        """Only one cell can be selected at a time."""
        MULTI_CELL: Arrow._SelectionMode.ValueType  # 5
        """Multiple cells (continuous range) can be selected."""

    class SelectionMode(_SelectionMode, metaclass=_SelectionModeEnumTypeWrapper):
        """Available selection modes:"""

    SINGLE_ROW: Arrow.SelectionMode.ValueType  # 0
    """Only one row can be selected at a time."""
    MULTI_ROW: Arrow.SelectionMode.ValueType  # 1
    """Multiple rows can be selected at a time."""
    SINGLE_COLUMN: Arrow.SelectionMode.ValueType  # 2
    """Only one column can be selected at a time."""
    MULTI_COLUMN: Arrow.SelectionMode.ValueType  # 3
    """Multiple columns can be selected at a time."""
    SINGLE_CELL: Arrow.SelectionMode.ValueType  # 4
    """Only one cell can be selected at a time."""
    MULTI_CELL: Arrow.SelectionMode.ValueType  # 5
    """Multiple cells (continuous range) can be selected."""

    class _BorderMode:
        ValueType = _typing.NewType("ValueType", _builtins.int)
        V: _TypeAlias = ValueType  # noqa: Y015

    class _BorderModeEnumTypeWrapper(_enum_type_wrapper._EnumTypeWrapper[Arrow._BorderMode.ValueType], _builtins.type):
        DESCRIPTOR: _descriptor.EnumDescriptor
        ALL: Arrow._BorderMode.ValueType  # 0
        """Show borders around the table and between cells."""
        NONE: Arrow._BorderMode.ValueType  # 1
        """Show no borders."""
        HORIZONTAL: Arrow._BorderMode.ValueType  # 2
        """Show only horizontal borders between rows."""

    class BorderMode(_BorderMode, metaclass=_BorderModeEnumTypeWrapper):
        """Available border modes:"""

    ALL: Arrow.BorderMode.ValueType  # 0
    """Show borders around the table and between cells."""
    NONE: Arrow.BorderMode.ValueType  # 1
    """Show no borders."""
    HORIZONTAL: Arrow.BorderMode.ValueType  # 2
    """Show only horizontal borders between rows."""

    DATA_FIELD_NUMBER: _builtins.int
    STYLER_FIELD_NUMBER: _builtins.int
    WIDTH_FIELD_NUMBER: _builtins.int
    HEIGHT_FIELD_NUMBER: _builtins.int
    USE_CONTAINER_WIDTH_FIELD_NUMBER: _builtins.int
    ID_FIELD_NUMBER: _builtins.int
    COLUMNS_FIELD_NUMBER: _builtins.int
    EDITING_MODE_FIELD_NUMBER: _builtins.int
    DISABLED_FIELD_NUMBER: _builtins.int
    FORM_ID_FIELD_NUMBER: _builtins.int
    COLUMN_ORDER_FIELD_NUMBER: _builtins.int
    SELECTION_MODE_FIELD_NUMBER: _builtins.int
    ROW_HEIGHT_FIELD_NUMBER: _builtins.int
    BORDER_MODE_FIELD_NUMBER: _builtins.int
    PLACEHOLDER_FIELD_NUMBER: _builtins.int
    data: _builtins.bytes
    """The serialized arrow dataframe"""
    @_builtins.property
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def width(self) -> _builtins.int:
        """DEPRECATED: Width in pixels. Use Element.width_config instead."""

    @width.setter
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def width(self, value: _builtins.int) -> None:
        """DEPRECATED: Width in pixels. Use Element.width_config instead."""

    @_builtins.property
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def height(self) -> _builtins.int:
        """DEPRECATED: Height in pixels. Use Element.height_config instead."""

    @height.setter
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def height(self, value: _builtins.int) -> None:
        """DEPRECATED: Height in pixels. Use Element.height_config instead."""

    @_builtins.property
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def use_container_width(self) -> _builtins.bool:
        """DEPRECATED: Use Element.width_config.use_stretch instead."""

    @use_container_width.setter
    @_deprecated("""This field has been marked as deprecated using proto field options.""")
    def use_container_width(self, value: _builtins.bool) -> None:
        """DEPRECATED: Use Element.width_config.use_stretch instead."""

    id: _builtins.str
    """The id of the widget, this is required if the dataframe is editable"""
    columns: _builtins.str
    """Column configuration as JSON"""
    editing_mode: Global___Arrow.EditingMode.ValueType
    """Activate table editing"""
    disabled: _builtins.bool
    """Deactivates editing"""
    form_id: _builtins.str
    """The form ID of the widget, this is required if the dataframe is editable"""
    row_height: _builtins.int
    """Row height in pixels"""
    border_mode: Global___Arrow.BorderMode.ValueType
    """How to show borders around the table and between cells. Note that this property
    is only used for `st.table` at the moment.
    """
    placeholder: _builtins.str
    """Placeholder string used when rendering missing values (e.g. nulls, NaNs)."""
    @_builtins.property
    def styler(self) -> Global___Styler:
        """Pandas styler information"""

    @_builtins.property
    def column_order(self) -> _containers.RepeatedScalarFieldContainer[_builtins.str]:
        """Defines the order in which columns are displayed"""

    @_builtins.property
    def selection_mode(self) -> _containers.RepeatedScalarFieldContainer[Global___Arrow.SelectionMode.ValueType]:
        """Activated dataframe selections events"""

    def __init__(
        self,
        *,
        data: _builtins.bytes = ...,
        styler: Global___Styler | None = ...,
        width: _builtins.int = ...,
        height: _builtins.int = ...,
        use_container_width: _builtins.bool = ...,
        id: _builtins.str = ...,
        columns: _builtins.str = ...,
        editing_mode: Global___Arrow.EditingMode.ValueType = ...,
        disabled: _builtins.bool = ...,
        form_id: _builtins.str = ...,
        column_order: _abc.Iterable[_builtins.str] | None = ...,
        selection_mode: _abc.Iterable[Global___Arrow.SelectionMode.ValueType] | None = ...,
        row_height: _builtins.int | None = ...,
        border_mode: Global___Arrow.BorderMode.ValueType = ...,
        placeholder: _builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: _TypeAlias = _typing.Literal["_placeholder", b"_placeholder", "_row_height", b"_row_height", "placeholder", b"placeholder", "row_height", b"row_height", "styler", b"styler"]  # noqa: Y015
    def HasField(self, field_name: _HasFieldArgType) -> _builtins.bool: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["_placeholder", b"_placeholder", "_row_height", b"_row_height", "border_mode", b"border_mode", "column_order", b"column_order", "columns", b"columns", "data", b"data", "disabled", b"disabled", "editing_mode", b"editing_mode", "form_id", b"form_id", "height", b"height", "id", b"id", "placeholder", b"placeholder", "row_height", b"row_height", "selection_mode", b"selection_mode", "styler", b"styler", "use_container_width", b"use_container_width", "width", b"width"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__placeholder: _TypeAlias = _typing.Literal["placeholder"]  # noqa: Y015
    _WhichOneofArgType__placeholder: _TypeAlias = _typing.Literal["_placeholder", b"_placeholder"]  # noqa: Y015
    _WhichOneofReturnType__row_height: _TypeAlias = _typing.Literal["row_height"]  # noqa: Y015
    _WhichOneofArgType__row_height: _TypeAlias = _typing.Literal["_row_height", b"_row_height"]  # noqa: Y015
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__placeholder) -> _WhichOneofReturnType__placeholder | None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__row_height) -> _WhichOneofReturnType__row_height | None: ...

Global___Arrow: _TypeAlias = Arrow  # noqa: Y015

@_typing.final
class Styler(_message.Message):
    DESCRIPTOR: _descriptor.Descriptor

    UUID_FIELD_NUMBER: _builtins.int
    CAPTION_FIELD_NUMBER: _builtins.int
    STYLES_FIELD_NUMBER: _builtins.int
    DISPLAY_VALUES_FIELD_NUMBER: _builtins.int
    uuid: _builtins.str
    """The Styler's source UUID (if the user provided one), or the path-based
    hash that we generate (if no source UUID was provided).
    """
    caption: _builtins.str
    """The table's caption."""
    styles: _builtins.str
    """`styles` contains the CSS for the entire source table."""
    display_values: _builtins.bytes
    """display_values is another ArrowTable: a copy of the source table, but
    with all the display values formatted to the user-specified rules.
    """
    def __init__(
        self,
        *,
        uuid: _builtins.str = ...,
        caption: _builtins.str = ...,
        styles: _builtins.str = ...,
        display_values: _builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: _TypeAlias = _typing.Literal["caption", b"caption", "display_values", b"display_values", "styles", b"styles", "uuid", b"uuid"]  # noqa: Y015
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___Styler: _TypeAlias = Styler  # noqa: Y015
