# ATHENODE Auth/Billing Server

Serveren håndterer:
- konto-login
- roller (user/admin)
- abonnement-status server-side
- Stripe checkout + webhook-opdatering af abonnement

## Start

```bash
./scripts/run_auth_server.sh
```

Default endpoint: `http://0.0.0.0:8080` (tilgaengelig fra andre maskiner paa samme netvaerk via serverens IP).

## Kobl appen på serveren

Saet i samme shell som du starter Streamlit fra (eksempel med server-IP `192.168.1.50`):

```bash
export EKSAMENAPP_AUTH_API_BASE=http://192.168.1.50:8080
```

## Nødvendige miljøvariabler (server)

- `EKSAMENAPP_SERVER_JWT_SECRET` (sæt en stærk hemmelighed)
- `EKSAMENAPP_ADMIN_PASSWORD` (anbefales sat)

Valgfrit for Stripe:
- `STRIPE_SECRET_KEY`
- `STRIPE_WEBHOOK_SECRET`
- `STRIPE_PAYMENT_METHOD_TYPES` (fx `card` eller `card,mobilepay` hvis understøttet)

Valgfrit for app-opdateringer:
- `EKSAMENAPP_LATEST_VERSION` (fx `0.2.3`)
- `EKSAMENAPP_MIN_SUPPORTED_VERSION` (blokkerer ældre klienter, fx `0.2.0`)
- `EKSAMENAPP_DOWNLOAD_URL` (link til nyeste `.dmg`/`.zip`)
- `EKSAMENAPP_RELEASE_NOTES` (kort tekst)
- `EKSAMENAPP_RELEASED_AT` (fx `2026-03-01`)

Appen henter disse værdier fra:

```text
GET /v1/app/update
```

Hvis `minimum_supported_version` er højere end klientens version,
bliver brugeren stoppet med krav om opdatering.

## Stripe webhook lokalt (eksempel)

```bash
stripe listen --forward-to http://127.0.0.1:8080/v1/webhooks/stripe
```

Brug den viste webhook secret som `STRIPE_WEBHOOK_SECRET`.

## MobilePay

Selve serveren er klar til gateway-baseret payment method konfiguration,
men du skal selv have MobilePay aktiveret hos din PSP/gateway (fx Stripe/Quickpay/Nets),
inkl. merchant-opsætning og credentials.
