#!/usr/bin/env bash
set -euo pipefail

cd "$(dirname "$0")/.."

if [ ! -d ".venv" ]; then
  python3 -m venv .venv
fi

# shellcheck disable=SC1091
source .venv/bin/activate

python -m pip install --upgrade pip
python -m pip install -r server/requirements.txt

export EKSAMENAPP_SERVER_DB="${EKSAMENAPP_SERVER_DB:-./server/data/app.db}"
export EKSAMENAPP_SERVER_JWT_SECRET="${EKSAMENAPP_SERVER_JWT_SECRET:-dev-change-this-secret}"

HOST="${HOST:-0.0.0.0}"
PORT="${PORT:-8080}"
echo "Auth server starter paa http://${HOST}:${PORT}"
exec uvicorn server.app:app --host "${HOST}" --port "${PORT}" --reload
