# ATHENODE Packaging Roadmap

This roadmap is focused on shipping safely to other users while keeping GDPR boundaries clear:
- user OneNote data stays on user device
- server stores only account/billing/license data

## Phase 1: Testable On Another Machine (now)

Goal: another user can run app from source with minimal setup.

Deliverables:
- `scripts/run_local.sh`, `scripts/run_windows.bat`, `scripts/run_mac.command`
- `scripts/preflight_check.sh` for machine readiness
- server mode flag via `EKSAMENAPP_AUTH_API_BASE`

Exit criteria:
- clean machine can run `./scripts/preflight_check.sh`
- app starts and login/register works
- OneNote fetch/index/query works locally

## Phase 2: Beta Distribution Package

Goal: reduce setup friction for non-technical testers.

Deliverables:
- release ZIP per OS with:
  - app source
  - setup instructions
  - `.env.example`
  - one-click launcher scripts
- first-run wizard/checklist in app
- diagnostics export button for support

Exit criteria:
- pilot users can self-install with <= 10 minutes setup
- support issues are reproducible with diagnostics bundle

## Phase 3: Signed Desktop Installer

Goal: true app install experience (`.app`/`.exe`) with trusted binaries.

Deliverables:
- packaging pipeline (PyInstaller or Briefcase)
- macOS signing + notarization
- Windows code signing
- auto-update strategy and versioned releases

Exit criteria:
- installer works on clean macOS + Windows
- signed binaries pass OS trust checks
- rollback plan exists for failed releases

## Notes For GDPR And Monetization

- If monetization is required, keep auth/license server centralized.
- Do not upload OneNote exports, embeddings, or chat context to server.
- Store only minimum account/billing metadata server-side.
