# ATHENODE: Pakning og Distribution

## 1) Lokal distribution (anbefalet ift. GDPR)

Brugerne kører appen på egen computer med egne nøgler.
Der hostes ikke brugerdata eller OneNote-eksporter på en central server.

### macOS/Linux

```bash
./scripts/run_local.sh
```

Eller dobbeltklik på `scripts/run_mac.command` på macOS.

### Windows

Kør:

```bat
scripts\run_windows.bat
```

### Windows desktop build (PyInstaller)

Byg Windows x64 artifact (koer i PowerShell paa en x64 Windows-maskine):

```powershell
.\scripts\build_windows_bundle.ps1 -Arch x64
```

Byg Windows ARM64 artifact (koer i PowerShell paa en ARM64 Windows-maskine/VM):

```powershell
.\scripts\build_windows_bundle.ps1 -Arch arm64
```

Alternativt via CMD-wrapper:

```bat
scripts\build_windows_bundle.cmd -Arch x64
```

Output:
- `dist/athenode_desktop_windows_<arch>_<timestamp>.zip`
- `dist/athenode_desktop_windows_<arch>_<timestamp>.zip.sha256`

## 1.1) Preflight check (ny maskine)

Koer altid denne foerst paa en ny maskine:

```bash
./scripts/preflight_check.sh
```

Den checker:
- Python version (>=3.11)
- at noeglefiler findes (`Main.py`, requirements, server app)
- import af core/optional/server dependencies
- om auth server svarer paa `/health` hvis `EKSAMENAPP_AUTH_API_BASE` er sat

Hvis du ser fejl om `Ixml`, er det typisk en typo for `lxml`.
I dette projekt er pakken korrekt sat til `lxml` i `requirements-optional.txt`.

## 1.2) Byg testbar release-zip

Byg en ren source-pakke til deling/test:

```bash
./scripts/build_release_zip.sh
```

Output ligger i `dist/`:
- `athenode_source_<timestamp>.zip`
- `athenode_source_<timestamp>.zip.sha256` (hvis `shasum` findes)

## 1.3) Byg delbar desktop-zip (fra PyInstaller bundle)

Naar `dist/ATHENODE-desktop/` findes, kan du pakke den til en enkelt fil:

```bash
./scripts/build_desktop_release_zip.sh
```

Output:
- `dist/athenode_desktop_<os>_<arch>_<timestamp>.zip`
- `dist/athenode_desktop_<os>_<arch>_<timestamp>.zip.sha256`

Hvis du vil bygge bundle + zip i samme step:

```bash
REBUILD_BUNDLE=1 ./scripts/build_desktop_release_zip.sh
```

## 1.4) macOS distribution som .app + .dmg

Byg macOS app-bundle:

```bash
./scripts/build_macos_app.sh
```

Output:
- `dist/ATHENODE.app`

Byg DMG til deling (drag-to-Applications):

```bash
./scripts/build_macos_dmg.sh
```

Output:
- `dist/athenode_macos_<arch>_<timestamp>.dmg`
- `dist/athenode_macos_<arch>_<timestamp>.dmg.sha256`

Hvis `hdiutil` fejler i dit miljoe, laver scriptet automatisk en fallback:
- `dist/athenode_macos_<arch>_<timestamp>.zip` (med `.app` bundle)

Byg app + DMG i et step:

```bash
REBUILD_APP=1 ./scripts/build_macos_dmg.sh
```

Fejlsoegning paa macOS:
- launcher-log: `~/Library/Application Support/ATHENODE/logs/launcher.log`
- start app fra terminal for at se fejl direkte:
  - `/path/to/ATHENODE.app/Contents/MacOS/ATHENODE`
- hvis Gatekeeper blokerer en downloadet app, fjern quarantine-attribut:
  - `xattr -dr com.apple.quarantine /path/to/ATHENODE.app`

Auto-luk ved lukket browser (desktop bundle):
- Launcher saetter nu default auto-exit naar sidste browser-session er lukket.
- Standard: lukker efter 45 sekunder uden aktive browser-sessioner.
- Kan overstyres via env vars:
  - `EKSAMENAPP_EXIT_ON_NO_BROWSER=1|0`
  - `EKSAMENAPP_EXIT_IDLE_GRACE_SEC=45`
  - `EKSAMENAPP_EXIT_STARTUP_GRACE_SEC=120`
  - `EKSAMENAPP_EXIT_POLL_SEC=1.0`

## 1.5) Sikker semiautomatisk git sync (ny)

Brug dette script i stedet for manuelle `git add/commit/push`.
Det stopper hvis Python-koden ikke kan compiles.

```bash
./scripts/safe_sync.sh "Din commit-besked"
```

Valgfrit: koer testkommando foer commit/push:

```bash
SAFE_SYNC_TEST_CMD="pytest -q" ./scripts/safe_sync.sh "Din commit-besked"
```

Valgfrit: commit uden push:

```bash
SAFE_SYNC_SKIP_PUSH=1 ./scripts/safe_sync.sh "Din commit-besked"
```

## 2) Forudsætninger pr. bruger

- Python 3.11+
- Internetadgang til Microsoft Graph
- Microsoft-konto i den understøttede skole-tenant (login sker i appens login-side)
- Egen OpenAI nøgle hvis `provider=openai`
- (Valgfrit) lokal Ollama hvis `provider=ollama`
- Hvis OCR/attachment parsing skal virke fuldt: installer også `requirements-optional.txt`

## 3) Server-side monetization (ny)

Appen understøtter nu en separat auth/billing-server (`server/app.py`) som validerer konti, roller og abonnementer server-side.
OneNote-filer og embeddings bliver stadig på brugerens computer.

### 3.1 Start auth-server

```bash
./scripts/run_auth_server.sh
```

Server kører default på `http://0.0.0.0:8080` (brug serverens LAN-IP fra klientmaskiner).
Se også [server/README.md](/Users/gustavkjeldsen/PycharmProjects/EKSAMENAPP/server/README.md).

### 3.2 Peg Streamlit-app på serveren

Sæt miljøvariabel før app-start:

```bash
export EKSAMENAPP_AUTH_API_BASE=http://192.168.1.50:8080
```

Når den er sat, bruger appen server-login i stedet for lokal brugerfil.

### 3.3 App-opdateringer (ny)

Du kan styre klient-opdateringer centralt via auth-serveren.
Sæt disse miljøvariabler på serveren:

- `EKSAMENAPP_LATEST_VERSION` (fx `0.2.3`)
- `EKSAMENAPP_MIN_SUPPORTED_VERSION` (fx `0.2.0`)
- `EKSAMENAPP_DOWNLOAD_URL` (offentligt link til ny `.dmg`/`.zip`)
- `EKSAMENAPP_RELEASE_NOTES` (kort tekst, valgfri)
- `EKSAMENAPP_RELEASED_AT` (dato, valgfri)

Klienten viser:
- advarsel ved ny version (`latest_version` > klient-version)
- hard block hvis klient-version < `minimum_supported_version`

Praktisk flow:
1. Byg ny release (`.dmg`/`.zip`).
2. Upload filen til et offentligt downloadsted (fx GitHub Releases eller anden filhost).
3. Opdater serverens env vars med ny version + download URL.
4. Genstart serveren/deploy.

### 3.4 Admin testkonto

- Brugernavn: `admin`
- Password: `admin1234` (eller værdi i `EKSAMENAPP_ADMIN_PASSWORD`)

## 4) Betaling (Stripe + MobilePay-betingelser)

- Serveren opretter Stripe Checkout sessions og aktiverer abonnement ved webhook.
- Kræver: `STRIPE_SECRET_KEY` og (anbefalet) `STRIPE_WEBHOOK_SECRET`.
- Betalingsmetoder styres via `STRIPE_PAYMENT_METHOD_TYPES` (fx `card` eller `card,mobilepay`).
- Om `mobilepay` virker afhænger af din Stripe/gateway-konto og merchant-opsætning.

Hvis `mobilepay` ikke er aktiveret i din betalingsudbyder endnu, skal du:
1. Aktivere MobilePay hos din PSP/gateway (fx Stripe/Quickpay/Nets afhængigt af setup).
2. Få de nødvendige merchant credentials.
3. Sætte credentials i serverens miljøvariabler.
4. Teste webhook-flowet i sandbox før produktion.

## 5) Drift-noter

- App-data gemmes i brugerens lokale app-data mappe (eller `EKSAMENAPP_DATA_DIR`).
- Token-cache ligger lokalt under app-data (`auth/`).
- Understøttede skoler konfigureres i `SCHOOL_PRESETS` i `Main.py`.
- Brug appens "Data & Privacy" knapper til eksport/sletning.
- Ved ekstern serverdrift skal du etablere HTTPS, secrets management, backup, audit logs og databehandleraftale.

## 6) Roadmap

Se [PACKAGING_ROADMAP.md](/Users/gustavkjeldsen/PycharmProjects/EKSAMENAPP/PACKAGING_ROADMAP.md) for 3-faset plan:
- fase 1: testbar paa anden maskine (nu)
- fase 2: beta pakke
- fase 3: signeret installer

## 7) Fase-3 forberedelse (PyInstaller skeleton)

Der er nu et første skeleton under [packaging/pyinstaller/README.md](/Users/gustavkjeldsen/PycharmProjects/EKSAMENAPP/packaging/pyinstaller/README.md).

Byg desktop-bundle (ikke signeret installer endnu):

```bash
./scripts/build_pyinstaller_bundle.sh
```

Nyttige varianter:
- `SKIP_PIP_INSTALL=1 ./scripts/build_pyinstaller_bundle.sh` (offline/lukket miljoe)
- `INCLUDE_OPTIONAL_DEPS=1 ./scripts/build_pyinstaller_bundle.sh` (OCR/PDF deps med)

Resultat:
- `dist/ATHENODE-desktop/`
- `dist/ATHENODE.app` (via `./scripts/build_macos_app.sh` paa macOS)

CI (GitHub Actions):
- workflow: `.github/workflows/windows-desktop-build.yml`
- bygger altid `windows-x64` ved tag pushes (`v*`) og ved manuel koersel
- kan bygge `windows-arm64` ved manuel koersel med `build_arm64=true` (kraever self-hosted runner med labels: `self-hosted`, `Windows`, `ARM64`)
